def init(n):
	"""
	Crée un état initial
	
	:param n: Nombre de disques
	"""
	return [[i for i in range(n, 0, -1)], [], []]

def deplacer(T, i, j):
	"""
	Déplace le disque en haut du pilier ``i`` vers le pilier ``j``
	
	:param T: Etat du jeu actuel
	:param i: le pilier de départ
	:param j: le pilier d'arrivée
	"""
	assert len(T[i]), f"Le pilier {i} est vide, T={T}"
	assert i != j, f"Un déplacement d'un pilier ({i}) à lui-même est invalide"
	assert (not len(T[j]) or T[i][-1] < T[j][-1],
		 	f"Le disque en haut du pilier {i} ne peut être déplacer sur le pilier {j}, T={T}")
	T[j].append(T[i].pop())

def afficher(T):
	"""
	Affiche un état ``T``
	"""
	D = T[0] + T[1] + T[2]
	assert len(set(D)) == len(D), f"Certains disques apparaissent plusieurs fois, {T}"
	mi, ma = min(D), max(D)
	assert mi == 1, f"Le plus petit disque doit avoir une taille de 1, {T}"
	assert ma == len(D), f"Le plus petit disque doit avoir une taille de {len(D)}, {T}"
	for t in T:
		assert list(reversed(sorted(t))) == t, f"Les disques doivent se trouver sur des disques plus gros, {T}"
	s = 2*ma+1
	for i in range(len(D)-1, -1, -1):
		line = ""
		for t in T:
			if i < len(t):
				si = 2*t[i]+1
				sp = (s-si)//2
				line += " "*sp+"X"*si+" "*sp
			else:
				line += " "*ma+"|"+" "*ma
		print(line)
	print("="*(3*s))


def solution(n, i=0, j=2, k=1):
	"""
	Retourne une liste de déplacement à effectuer pour déplacer ``n`` disques
	du pilier ``i`` au pilier ``j`` en utilisant le pilier ``k``
	"""
	############################
	# TODO: Fonction à compléter
	############################
	sol = [(0, 1), (1, 0), (0, 2)]
	return sol


if __name__ == "__main__":
	n = 4
	T = init(n)
	sol = solution(n)
	afficher(T)
	for i, j in sol:
		deplacer(T, i, j)
		afficher(T)
