from random import randint

class Problem:
	def __init__(self, n, k):
		self.n = n
		self.k0 = k
		self.k = k
		self.l = randint(1, n+1)
		self.n_sauts = 0
	
	def nombre_etages(self):
		return self.n

	def nombre_etudiants(self):
		return self.k0

	def saut(self, etage):
		"""
		Test pour savoir si un saut est fatal.
		
		:param etage: l'étage duquel un élève saute

		:return fatal: booléen indiquant si le saut est fatal
		"""
		assert 1 <= etage
		assert etage <= self.n
		assert self.k > 0
		self.n_sauts += 1
		fatal = self.l <= etage
		if fatal: self.k -= 1
		return fatal

def naif(P:Problem):
	"""
	Solution naïve qui teste les étages les uns après les autres en partant du bas.
	"""
	n = 1
	while n <= P.nombre_etages() and not P.saut(n):
		n += 1
	return n


def Q1(P: Problem):
	############################
	# TODO: Fonction à compléter
	############################
	return 1

def Q2(P: Problem):
	############################
	# TODO: Fonction à compléter
	############################
	return 1

def Q3(P: Problem):
	############################
	# TODO: Fonction à compléter
	############################
	return 1


if __name__ == "__main__":
	P0 = Problem(100, 100)
	P1 = Problem(2**64, 96)
	P2 = Problem(2**48, 32)
	P3 = Problem(2**32, 2)
	for P, f, name in [(P0, naif, "Test algo naïf"), (P1, Q1, "Question 1"),
						(P2, Q2, "Question 2"), (P3, Q3, "Question 3")]:
		assert f(P) == P.l, f"Mauvaise réponse pour {name}"
		print(f"{name}: résolu en {P.n_sauts} sauts, {P.k}/{P.k0} survivants.")
