#include <algorithm>
#include <cassert>
#include <chrono>
#include <iomanip>
#include <iostream>
#include <random>
#include <vector>

#include "file_priorite.h"

//==========================//
// LISTE DOUBLEMENT CHAINEE //
//==========================//

bool Liste::vide() {
	/**************************************************
	* TODO: Fonction à compléter
	* @return true si et seulement si la liste est vide
	**************************************************/
	return true;
}

void Liste::ajouter_fin(int x) {
	/**************************************************
	* TODO: Fonction à compléter
	* Ajoute une nouvelle cellule en fin de liste
	* @param x La valeur à ajouter à la fin de la liste
	**************************************************/
}

void Liste::ajouter_trie(int x) {
	/*********************************************************
	* TODO: Fonction à compléter
	* Ajoute une nouvelle cellule en maintenant la liste triée
	* @param x La valeur à ajouter à la liste
	*********************************************************/
}

void Liste::retirer(Cellule *c) {
	/*******************************************
	* TODO: Fonction à compléter
	* Retire et supprime une cellule de la liste
	* Attention : doit mettre à jour le debut
	*             et la fin de la liste
	* @param c La cellule à supprimer
	*******************************************/
}



//====================================//
// IMPLEMENTATION DE FILE DE PRIORITE //
// AVEC UNE LISTE DOUBLEMENT CHAINEE  //
//====================================//

/***************************************
 * Implémentation d'une file de priorité
 * avec une liste non triée
 **************************************/
int FilePrioriteA::retirer() {
	/*****************************************************
	* TODO: Fonction à compléter
	* Retire la plus grande valeur de la file de priorité
	* @return La plus grande valeur de la file de priorité
	*****************************************************/
	assert(!vide());
	return 0;
}

/***************************************
 * Implémentation d'une file de priorité
 * avec une liste triée
 **************************************/
int FilePrioriteB::retirer() {
	/*****************************************************
	* TODO: Fonction à compléter
	* Retire la plus grande valeur de la file de priorité
	* @return La plus grande valeur de la file de priorité
	*****************************************************/
	assert(!vide());
	return 0;
}



//======//
// MAIN //
//======//

int main() {
	using namespace std;

	mt19937 mt;
	const int n = 1e4;
	vector<int> v(n);
	for(int &x : v) x = uniform_int_distribution(0, n)(mt);
	vector<int> w = v;
	sort(w.rbegin(), w.rend());

	using clock = chrono::high_resolution_clock;
	cout << fixed << setprecision(6);
	FilePriorite* Q[] {new FilePrioriteA(), new FilePrioriteB(), new FilePrioriteC()};
	for(int t = 0; t < 3; ++t) {
		FilePriorite* q = Q[t];
		clock::time_point t0 = clock::now();
		for(int x : v) q->ajouter(x);
		chrono::duration<double> dt = clock::now()-t0;
		cout << "File de Priorité " << "ABC"[t] << " :\n";
		cout << "\tInsertions:  " << dt.count() << "s" << endl;
		bool good = true;
		t0 = clock::now();
		for(int x : w) {
			if(q->vide()) {
				good = false;
				break;
			}
			if(q->retirer() != x) good = false;
		}
		if(!q->vide()) good = false;
		dt = clock::now()-t0;
		cout << "\tSuppresions: " << dt.count() << "s\n";
		cout << "\t" << (good ? "Correct" : "Incorrect") << endl;
	}
	return 0;
}
