#pragma once

#include <queue>

//==========================//
// LISTE DOUBLEMENT CHAINEE //
//==========================//

struct Cellule {
	int valeur;
	Cellule *precedent, *suivant;
};

struct Liste {
	Cellule *debut = nullptr, *fin = nullptr;

	bool vide();
	void ajouter_fin(int x);
	void ajouter_trie(int x);
	void retirer(Cellule *c);
};

//==================//
// TYPE ABSTRAIT :  //
// FILE DE PRIORITE //
//==================//

struct FilePriorite {
	virtual bool vide() = 0;
	virtual void ajouter(int) = 0;
	virtual int retirer() = 0;
};

//====================================//
// IMPLEMENTATION DE FILE DE PRIORITE //
// AVEC UNE LISTE DOUBLEMENT CHAINEE  //
//====================================//

struct FilePriorite_Liste : FilePriorite {
protected:
	Liste liste;
public:
	bool vide() { return liste.vide(); }
};

/***************************************
 * Implémentation d'une file de priorité
 * avec une liste non triée
 **************************************/
struct FilePrioriteA : FilePriorite_Liste {
	void ajouter(int x) { liste.ajouter_fin(x); }
	int retirer();
};

/***************************************
 * Implémentation d'une file de priorité
 * avec une liste triée
 **************************************/
struct FilePrioriteB : FilePriorite_Liste  {
	void ajouter(int x) { liste.ajouter_trie(x); }
	int retirer();
};

/*****************************************
 * Implémentation d'une file de priorité
 * avec la structure priority_queue de C++
 ****************************************/
struct FilePrioriteC : FilePriorite  {
protected:
	std::priority_queue<int> Q;
public:
	bool vide() { return Q.empty(); };
	void ajouter(int x) { Q.push(x); };
	int retirer() { const int x = Q.top(); Q.pop(); return x; };
};
