#pragma once

#include <vector>

/**
 * @brief Structure de graphe (orienté)
 */
struct Graphe {
	int n; ///< Nombre de sommets

	/**
	 * Listes d'adjacence
	 * A[i] est un vecteur des voisins de i
	 */
	std::vector<std::vector<int>> A;

	/**
	 * @brief Créer un graphe contenant n sommets
	 * 
	 * @param n Le nombre de sommets
	 */
	Graphe(int n): n(n), A(n) {}
};



/**
 * @brief Structure d'arc pondéré
 */
struct Arc {
	int destination;
	int poids;

	Arc(int destination, int poids):
		destination(destination),
		poids(poids)
		{}
};


/**
 * @brief Structure de graphe pondéré
 */
struct GrapheP {
	int n; ///< Nombre de sommets

	/**
	 * Listes d'adjacence
	 * A[i] est un vecteur des voisins de i
	 */
	std::vector<std::vector<Arc>> A;

	/**
	 * @brief Créer un graphe contenant n sommets
	 * 
	 * @param n Le nombre de sommets
	 */
	GrapheP(int n): n(n), A(n) {}
};
