#include <iostream>
#include <vector>
#include <tuple>
#include <fstream>
#include <limits>
#include <queue>

#include "graphe.h"

/**
 * @brief Tas binaire stockant le sommet se trouvant
 * à la plus petite distance en racine
 * 
 * TODO: Structure à implémenter uniquement lorsque dijkstra
 * fonctionne corretement avec une std::priority_queue
 */
struct Tas {
	std::vector<std::pair<int, int>> T;

	Tas(): T(1) {}

	/**
	 * @return true si le tas est vide
	 */
	bool vide() const { return T.size() == 1; }

	/**
	 * @brief Ajoute un nouvel élément au tas
	 * @param d La distance de l'élément ajouté
	 * @param u le sommet de l'élément ajouté
	 */
	void ajouter(int d, int u) {
		///////////////////
		// CODE MANQUANT //
		///////////////////
	}

	/**
	 * @brief Retirer le minimum du tas en le retournant
	 */
	std::pair<int, int> retirer() {
		auto x = T[1];
		///////////////////
		// CODE MANQUANT //
		///////////////////
		return x;
	}
};

/**
 * @brief Construit un graphe pondéré à partir des lignes
 * du labyrinthe
 * 
 * @param n le nombre de lignes du labyrinthe
 * @param m la longueur des lignes du labyrinthe
 * @param labyrinthe un vecteur des lignes du labyrinthe
 * 
 * @return un tuple contenant un graphe pondéré G représentant
 * le labyrinthe ainsi que deux sommets s et t
 * - s est le sommet source correspondant à la case en haut à
 *   gauche du labyrinthe
 * - t est la destination correspondant à la case en bas à
 *   droite du labyrinthe
 * 
 * TODO: Fonction à implémenter
 */
std::tuple<GrapheP, int, int> construire_graphe(int n, int m, const std::vector<std::string> &labyrinthe) {
	const int N = n*m;
	auto tup = std::make_tuple(GrapheP(N), 0, 0);
	auto &[G, s, t] = tup;

	///////////////////////////////////
	// CODE MANQUANT                 //
	// VOUS DEVEZ MODIFIER G, s et t //
	///////////////////////////////////

	return tup;
}

/**
 * @brief Applique l'algorithme de Dijkstra pour calculer
 * les distances depuis une source dans un graphe.
 * 
 * @param G Graphe pondéré d'entrée
 * @param s Sommet source du parcours
 * 
 * @return Un vecteur d, tel que d[i] est la distance
 *         entre s et i
 * 
 * TODO: Fonction à implémenter
 */
std::vector<int> dijkstra(const GrapheP &G, int s) {
	// On initialise distance avec la plus grande valeur possible
	// pour un int
	std::vector<int> distance(G.n, std::numeric_limits<int>::max());

	///////////////////
	// CODE MANQUANT //
	///////////////////

	return distance;
}

int main(int argc, char* argv[]) {
	////////////////////////////////////////////
	//  LECTURE DU FICHIER D'ENTREE   //////////
	////////////////////////////////////////////

	if(argc != 2) {
		std::cerr << "Mauvais nombre d'arguments : " << argc-1 << " (1 argument attendu)\n";
		std::cerr << "Utilisation:\n\t" << argv[0] << " labyrinthe.txt\n";
		std::cerr << "labyrinthe.txt est un fichier texte contenant un labyrinthe.\n";
		return 1;
	}
	std::ifstream fichier(argv[1]);
	if(!fichier) {
		std::cerr << "Erreur : Impossible d'ouvrir le fichier " << argv[1] << std::endl;
		return 1;
	}

	int n, m;
	if(!(fichier >> n) || !(fichier >> m)) {
		std::cerr << "Erreur : Impossible de lire les dimensions du labyrinthe sur la première ligne du fichier " << argv[1] << std::endl;
		return 1;
	}

	std::vector<std::string> labyrinthe(n);
	for(std::string &ligne : labyrinthe) {
		if(!(fichier >> ligne)) {
			std::cerr << "Erreur : Impossible de lire le labyrinthe du fichier " << argv[1] << std::endl;
			return 1;
		}
		if(ligne.size() != m) {
			std::cerr << "Erreur : Une ligne du labyrinthe dans le fichier " << argv[1] << " ne contient pas le bon nombre de caractères." << std::endl;
			std::cerr << "Nombre de caractères lus : " << ligne.size() << " (" << m << " attendu)" << std::endl;
			return 1;
		}
		for(char c : ligne) {
			if(c != '#' && (c < '1' || c > '9')) {
				std::cerr << "Erreur : Une ligne du labyrinthe dans le fichier " << argv[1] << " contient un mauvais caractère." << std::endl;
				std::cerr << "Caractère " << c << " non reconnu.." << std::endl;
				return 1;
			}
		}
	}

	std::cout << "Labyrinthe correctement lu" << std::endl;

	////////////////////////////////////////////
	//  VOTRE CODE EST APPELE ICI   ////////////
	////////////////////////////////////////////

	const auto [G, s, t] = construire_graphe(n, m, labyrinthe);
	const std::vector<int> distance = dijkstra(G, s);
	const int solution = distance[t];
	std::cout << "Distance calculée: " << solution << std::endl;

	return 0;
}