#include <iostream>
#include <limits>

#include "graphe.h"

/**
 * @brief Effectue un parcours en largeur pour calculer la distance
 * entre un sommet source et les autres sommets du graphe.
 * 
 * @param G Graphe d'entrée
 * @param s Sommet source du parcours
 * 
 * @return Un vecteur d, tel que d[i] est la distance
 *         entre s et i
 * 
 * TODO: Fonction à implémenter
 */
std::vector<int> parcours_largeur(const Graphe &G, int s) {
	// On initialise distance avec la plus grande valeur possible
	// pour un int
	std::vector<int> distance(G.n, std::numeric_limits<int>::max());

	///////////////////
	// CODE MANQUANT //
	///////////////////

	return distance;
}

int main() {
	using namespace std;
	
	const int d = 10;
	Graphe G(1<<d);
	for(int i = 0; i < G.n; ++i)
		for(int j = 0; j < d; ++j)
			G.A[i].push_back(i^(1<<j));
	const vector<int> dist = parcours_largeur(G, 0);
	if(dist.size() != G.n) {
		cerr << "Le vecteur de distances retourné, n'a pas la bonne taille : "
			<< dist.size() << " (" << G.n << " attendu)" << endl;
		return 1;
	}
	for(int i = 0; i < G.n; ++i) {
		int c = 0;
		for(int j = i; j; j >>= 1) c += j&1;
		if(dist[i] != c) {
			cerr << "Mauvaise réponse:\n";
			cerr << "\tdist[" << i << "] = " << dist[i] << " (" << c << " attendu)" << endl;
			return 1;
		}
	}
	cout << "Bonne réponse !!!!" << endl;

	return 0;
}