#include <iostream>
#include <random>
#include <set>
#include <vector>

using namespace std;

struct Cellule {
	int valeur;
	Cellule *pere, *fils_droit, *fils_gauche;
};

struct ABR {
	Cellule *racine;
	ABR(): racine(nullptr) {}

	/**
	 * @brief Recherche la valeur x dans l'ABR
	 * @return un pointeur nullptr si l'ABR ne contient pas x,
	 *   un pointeur vers la cellule contenant x si elle existe
	 * TODO: Fonction à implémenter
	 */
	Cellule* recherche(int x) {
		return nullptr;
	}

	/**
	 * @brief Ajoute la valeur x à l'ABR
	 * TODO: Fonction à implémenter
	 */
	void ajouter(int x) {

	}

	/**
	 * @brief Supprime la cellule c de l'ABR
	 * TODO: Fonction à implémenter
	 */
	void supprimer(Cellule* c) {

	}
};

int main() {
	using namespace std;

	const int M = 1e7;
	const int n = 1e4;
	mt19937 mt;

	auto test = [](ABR &A, const set<int> &S, int x) {
		Cellule* c = A.recherche(x);
		const bool a = c != nullptr;
		if(a && c->valeur != x) {
			cout << "Erreur:\n";
			cout << "Votre ABR a retourner une cellule avec une valeur " << c->valeur << " en recherchant " << x << "\n";
			exit(1);
		}
		const bool b = S.count(x);
		if(a==b) return;
		cout << "Erreur:\n";
		if(a) cout << "Votre ABR contient l'element " << x << " alors qu'il ne doit pas le contenir\n";
		else cout << "Votre ABR ne contient pas l'element " << x << " alors qu'il doit pas le contenir\n";
		exit(1);
	};

	// Phase 1
	{
		cout << "==== PHASE 1 : Teste de Ajouter et Recherche =====\n";
		ABR A;
		set<int> S;
		vector<int> v(n);
		for(int &x : v) x = mt()%M;
		const int stp = 100;
		for(int i = 0; i < n; ++i) {
			test(A, S, mt()%M);
			S.insert(v[i]);
			A.ajouter(v[i]);
			test(A, S, mt()%M);
			if(i%stp == 0)
				for(int j = 0; j <= i; ++j)
					test(A, S, v[j]);
		}
		cout << "  CORRECT !!!\n";
	}

	// Phase 2
	{
		cout << "==== PHASE 2 : Teste Complet =====\n";
		ABR A;
		set<int> S;
		vector<int> v(n), w;
		for(int &x : v) x = mt()%M;
		const int stp = 100;
		for(int i = 0; i < n; ++i) {
			test(A, S, mt()%M);
			S.insert(v[i]);
			A.ajouter(v[i]);
			w.push_back(v[i]);
			test(A, S, mt()%M);
			if(i%stp == 0) {
				for(int j = 0; j <= i; ++j)
					test(A, S, v[j]);
				if(i) {
					for(int j = 0; j < stp/2; ++j) {
						const int k = mt()%w.size();
						const int x = w[k];
						w[k] = w.back();
						w.pop_back();
						test(A, S, x);
						auto it = S.find(x);
						if(it == S.end()) continue;
						S.erase(it);
						A.supprimer(A.recherche(x));
					}
				}
			}
		}
		cout << "  CORRECT !!!\n";
	}

	return 0;
}