#include <iostream>
#include <random>
#include <unordered_set>
#include <vector>

using namespace std;

struct Table_Hachage {
	/// @brief La taille de la table
	constexpr static int M = 1000;

	std::vector<std::vector<int>> table;

	Table_Hachage(): table(M) {}

	/// @brief Fonction de hachage
	/// @param x la valeur à hacher
	/// @return le hash de x qui sert d'indice dans la table
	int h(int x) {
		return std::abs((x<<4)^(x>>6)) % M;
	}

	/// @brief Cherche si une valeur est présente dans la table
	/// @param x la valeur à tester
	/// @return true si et seulement si la table contient x
	/// TODO: Fonction à implémenter
	bool recherche(int x) {
		return false;
	}

	/// @brief Ajoute une nouvelle valeur à la table
	/// @param x la valeur à ajouter
	/// TODO: Fonction à implémenter
	void ajouter(int x) {

	}

	/// @brief Retire une valeur de la table
	/// @param x la valeur à retirer
	/// TODO: Fonction à implémenter
	void supprimer(int x) {

	}
};

int main() {
	using namespace std;

	const int M = 1e7;
	const int n = 1e4;
	mt19937 mt;

	auto test = [](Table_Hachage &A, const unordered_set<int> &S, int x) {
		const bool a = A.recherche(x);
		const bool b = S.count(x);
		if(a==b) return;
		cout << "Erreur:\n";
		if(a) cout << "Votre ABR contient l'element " << x << " alors qu'il ne doit pas le contenir\n";
		else cout << "Votre ABR ne contient pas l'element " << x << " alors qu'il doit pas le contenir\n";
		exit(1);
	};

	// Phase 1
	{
		cout << "==== PHASE 1 : Teste de Ajouter et Recherche =====\n";
		Table_Hachage A;
		unordered_set<int> S;
		vector<int> v(n);
		for(int &x : v) x = mt()%M;
		const int stp = 100;
		for(int i = 0; i < n; ++i) {
			test(A, S, mt()%M);
			S.insert(v[i]);
			A.ajouter(v[i]);
			test(A, S, mt()%M);
			if(i%stp == 0)
				for(int j = 0; j <= i; ++j)
					test(A, S, v[j]);
		}
		cout << "  CORRECT !!!\n";
	}

	// Phase 2
	{
		cout << "==== PHASE 2 : Teste Complet =====\n";
		Table_Hachage A;
		unordered_set<int> S;
		vector<int> v(n), w;
		for(int &x : v) x = mt()%M;
		const int stp = 100;
		for(int i = 0; i < n; ++i) {
			test(A, S, mt()%M);
			S.insert(v[i]);
			A.ajouter(v[i]);
			w.push_back(v[i]);
			test(A, S, mt()%M);
			if(i%stp == 0) {
				for(int j = 0; j <= i; ++j)
					test(A, S, v[j]);
				if(i) {
					for(int j = 0; j < stp/2; ++j) {
						const int k = mt()%w.size();
						const int x = w[k];
						w[k] = w.back();
						w.pop_back();
						test(A, S, x);
						auto it = S.find(x);
						if(it == S.end()) continue;
						S.erase(it);
						A.supprimer(x);
					}
				}
			}
		}
		cout << "  CORRECT !!!\n";
	}

	return 0;
}