from random import randint

class Problem:
	def __init__(self, n, k):
		self.n = n
		self.k0 = k
		self.k = k
		self.l = randint(1, n+1)
		self.n_sauts = 0
	
	def nombre_etages(self):
		return self.n

	def nombre_etudiants(self):
		return self.k0

	def nombre_etudiants_vivants(self):
		return self.k

	def saut(self, etage):
		"""
		Test pour savoir si un saut est fatal.
		
		:param etage: l'étage duquel un élève saute

		:return fatal: booléen indiquant si le saut est fatal
		"""
		assert 1 <= etage
		assert etage <= self.n
		assert self.k > 0
		self.n_sauts += 1
		fatal = self.l <= etage
		if fatal: self.k -= 1
		return fatal

def naif(P:Problem):
	"""
	Solution naïve qui teste les étages les uns après les autres en partant du bas.
	"""
	n = 1
	while n <= P.nombre_etages() and not P.saut(n):
		n += 1
	return n

def Q1(P: Problem):
	a = 1
	b = P.nombre_etages()+1
	while a < b:
		c = (a+b)//2
		if P.saut(c):
			b = c
		else:
			a = c+1
	return a

def Q2(P: Problem):
	a = 1
	b = P.nombre_etages()+1
	k = P.nombre_etudiants()
	for _ in range(k-1):
		c = (a+b)//2
		if P.saut(c):
			b = c
		else:
			a = c+1
	while a < b and not P.saut(a):
		a += 1
	return a

def Q3(P: Problem):
	n = P.nombre_etages()
	step = max(1, int(n**.5))
	a = 1
	while a+step <= n and not P.saut(a+step):
		a += step
	while a <= n and not P.saut(a):
		a += 1
	return a

if __name__ == "__main__":
	P0 = Problem(100, 100)
	P1 = Problem(2**64, 96)
	P2 = Problem(2**48, 32)
	P3 = Problem(2**32, 2)
	for P, f, name in [(P0, naif, "Test algo naïf"), (P1, Q1, "Question 1"),
						(P2, Q2, "Question 2"), (P3, Q3, "Question 3")]:
		assert f(P) == P.l, f"Mauvaise réponse pour {name}"
		print(f"{name}: résolu en {P.n_sauts} sauts, {P.k}/{P.k0} survivants.")