#include <algorithm>
#include <chrono>
#include <iomanip>
#include <iostream>
#include <random>

using namespace std;

int cardinal(const int* E, int n, int x) {
	int c = 0;
	for(int i = 0; i < n; ++i)
		if(E[i] == x)
			++ c;
	return c;
}

int Q1(const int* E, int n) {
	const int m = n / 2;
	for(int i = 0; i < n; ++i)
		if(cardinal(E, n, E[i]) > m)
			return E[i];
	return -1;
}

int Q2(const int* E, int n) {
	if(n == 1) return E[0];
	const int m = n / 2;
	const int x = Q2(E, m);
	const int y = Q2(E+m, m);
	if(x != -1 && cardinal(E, n, x) > m) return x;
	if(y != -1 && cardinal(E, n, y) > m) return y;
	return -1;
}

pair<int, int> Q3_aux(const int* E, int n) {
	if(n == 1) return {E[0], 1};
	const int m = n / 2;
	const auto [x, p] = Q3_aux(E, m);
	const auto [y, q] = Q3_aux(E+m, m);
	if(x == -1) {
		if(y == -1) return {-1, -1};
		return {y, q+m/2};
	} else {
		if(y == -1) return {x, p+m/2};
		if(x == y) return {x, p+q};
		if(p > q) return {x, p+m-q};
		if(p < q) return {y, q+m-p};
		return {-1, -1};
	}
}

int Q3(const int* E, int n) {
	const int x = Q3_aux(E, n).first;
	if(x != -1 && cardinal(E, n, x) > n/2) return x;
	return -1;
}

int main() {
	mt19937 mt;
	using clock = chrono::high_resolution_clock;
	cout << fixed << setprecision(6);
	const int delta = 20;
	for(const int p : {12, 15, 24}) {
		const int n = 1<<p;
		const int m = n/2+1;
		for(const auto &[mi, ma] : {pair<int, int>{m-delta, m}, {m, m+delta}}) {
			cout << "=========== taille " << n << ", solution = " << (ma==m ? '-' : ' ') << "1 ===========" << endl;
			const int k = mi + (mt() % (ma-mi));
			const int l = k + delta + (mt() % (n-2*delta - k));
			int* E = new int[n];
			fill_n(E+0, k-0, 1);
			fill_n(E+k, l-k, 2);
			fill_n(E+l, n-l, 3);
			shuffle(E, E+n, mt);
			const char* names[] = {"naïf", "2   ", "3   "};
			using Fun = int(*)(const int*, int);
			Fun fun[] = {Q1, Q2, Q3};
			for(int i = (p <= 15 ? 0 : 1); i < std::size(fun); ++i) {
				const clock::time_point t0 = clock::now();
				const int x = fun[i](E, n);
				const chrono::duration<double> dt = clock::now()-t0;
				cout << "Algorithme " << names[i] << " en " << dt.count() << "s, résultat = " << x << endl;
			}
		}
	}
	return 0;
}