#include <algorithm>
#include <cassert>
#include <chrono>
#include <iomanip>
#include <iostream>
#include <random>
#include <vector>

#include "file_priorite.h"

//==========================//
// LISTE DOUBLEMENT CHAINEE //
//==========================//

bool Liste::vide() {
	return debut == nullptr;
}

void Liste::ajouter_fin(int x) {
	if(fin == nullptr) {
		fin = debut = new Cellule;
		fin->precedent = nullptr;
	} else {
		fin->suivant = new Cellule;
		fin->suivant->precedent = fin;
		fin = fin->suivant;
	}
	fin->valeur = x;
	fin->suivant = nullptr;
}

void Liste::ajouter_trie(int x) {
	Cellule *c = debut;
	while(c != nullptr && c->valeur < x)
		c = c->suivant;
	if(c == nullptr) return ajouter_fin(x);
	Cellule *c2 = new Cellule;
	c2->valeur = x;
	c2->precedent = c->precedent;
	if(c2->precedent == nullptr) debut = c2;
	else c2->precedent->suivant = c2;
	c2->suivant = c;
	c->precedent = c2;
}

void Liste::retirer(Cellule *c) {
	assert(c != nullptr);
	if(c == debut) debut = c->suivant;
	if(c == fin) fin = c->precedent;
	if(c->suivant != nullptr) c->suivant->precedent = c->precedent;
	if(c->precedent != nullptr) c->precedent->suivant = c->suivant;
	delete c;
}



//====================================//
// IMPLEMENTATION DE FILE DE PRIORITE //
// AVEC UNE LISTE DOUBLEMENT CHAINEE  //
//====================================//

int FilePrioriteA::retirer() {
	assert(!vide());
	Cellule *m = nullptr;
	for(Cellule *c = liste.debut; c != nullptr; c = c->suivant) {
		if(m == nullptr || c->valeur > m->valeur)
			m = c;
	}
	const int x = m->valeur;
	liste.retirer(m);
	return x;
}

int FilePrioriteB::retirer() {
	assert(!vide());
	const int x = liste.fin->valeur;
	liste.retirer(liste.fin);
	return x;
}



//======//
// MAIN //
//======//

int main() {
	using namespace std;

	mt19937 mt;
	const int n = 1e4;
	vector<int> v(n);
	for(int &x : v) x = uniform_int_distribution(0, n)(mt);
	vector<int> w = v;
	sort(w.rbegin(), w.rend());

	using clock = chrono::high_resolution_clock;
	cout << fixed << setprecision(6);
	FilePriorite* Q[] {new FilePrioriteA(), new FilePrioriteB(), new FilePrioriteC()};
	for(int t = 0; t < 3; ++t) {
		FilePriorite* q = Q[t];
		clock::time_point t0 = clock::now();
		for(int x : v) q->ajouter(x);
		chrono::duration<double> dt = clock::now()-t0;
		cout << "File de Priorité " << "ABC"[t] << " :\n";
		cout << "\tInsertions:  " << dt.count() << "s" << endl;
		bool good = true;
		t0 = clock::now();
		for(int x : w) {
			if(q->vide()) {
				good = false;
				break;
			}
			if(q->retirer() != x) good = false;
		}
		if(!q->vide()) good = false;
		dt = clock::now()-t0;
		cout << "\tSuppresions: " << dt.count() << "s\n";
		cout << "\t" << (good ? "Correct" : "Incorrect") << endl;
	}
	return 0;
}
