#include <algorithm>
#include <chrono>
#include <iomanip>
#include <iostream>
#include <numeric>
#include <random>
#include <vector>

using namespace std;

void tri_insertion(int *T, const int n) {
	for(int i = 1; i < n; ++i) {
		const int x = T[i];
		int j = i;
		while(j && T[j-1] > x) {
			T[j] = T[j-1];
			--j;
		}
		T[j] = x;
	}
}

void tri_rapide(int *T, const int n) {
	if(n <= 1) return;
	const int x = T[0];
	int j = 0;
	for(int i = 1; i < n; ++i) {
		if(T[i] > x) continue;
		T[j] = T[i];
		++ j;
		T[i] = T[j];
	}
	T[j] = x;
	tri_rapide(T, j);
	tri_rapide(T+j+1, n-j-1);
}

void fusion(int *T, const int *L, const int n, const int *R, const int m) {
	int i = 0, j = 0, k = 0;
	while(i < n && j < m) {
		if(L[i] <= R[j])
			T[k++] = L[i++];
		else
			T[k++] = R[j++];
	}
	while(i < n) T[k++] = L[i++];
	while(j < m) T[k++] = R[j++];
}

void tri_fusion(int *T, const int n) {
	if(n <= 1) return;
	const int m = n/2;
	tri_fusion(T, m);
	tri_fusion(T+m, n-m);
	int* tmp = new int[m];
	for(int i = 0; i < m; ++i) tmp[i] = T[i];
	fusion(T, tmp, m, T+m, n-m);
	delete[] tmp;
}

int main() {
	mt19937 mt(45);
	using clock = chrono::high_resolution_clock;
	cout << fixed << setprecision(6);

	using Fun = void (*)(int*, int);
	pair<Fun, const char*> fs[] {
		{tri_insertion, "par insertion"},
		{tri_rapide,    "rapide       "},
		{tri_fusion,    "fusion       "},
	};
	vector<int> vs[] {vector<int>(10), vector<int>(3e4), vector<int>(3e4)};
	bool shuf[] {true, false, true};
	for(int i = 0; i < (int) std::size(vs); ++i) {
		iota(vs[i].begin(), vs[i].end(), 0);
		if(shuf[i]) shuffle(vs[i].begin(), vs[i].end(), mt); 
	}

	for(const auto &[f, name] : fs) {
		cout << "============ Test tri " << name << " ============" << '\n';
		for(int i = 0; i < (int) std::size(vs); ++i) {
			vector<int> v = vs[i];
			cout << "tri d'un tableau " << (shuf[i] ? "aléatoire" : "trié     ") << " de taille " << v.size() << "....." << endl;
			const clock::time_point t0 = clock::now();
			f(v.data(), v.size());
			const chrono::duration<double> dt = clock::now()-t0;
			bool bad = false;
			for(int i = 0; i < (int) v.size(); ++i) if(v[i] != i) bad = true;
			if(bad) {
				cout << "Incorrect..." << endl;
				if(v.size() > 10) break;
				cout << "Entree :";
				for(int x : vs[i]) cout << ' ' << x;
				cout << "\nSortie :";
				for(int x : v) cout << ' ' << x;
				cout << endl;
				break;
			}
			cout << "Correct !!! Tri calculé en " << dt.count() << "s" << endl;
		}
	}

	return 0;
}